package test;

import java.util.HashMap;

import javax.swing.plaf.basic.BasicInternalFrameTitlePane.MoveAction;

public class Room {

	public static final boolean IN = true;
	public static final boolean OUT = false;
	private boolean isCurrent = false;
	private HashMap<CardinalPoint, Boolean> passages;

	public Room() {
		this.passages = new HashMap<CardinalPoint, Boolean>();
		prepareMap();
	}
	
	public void openPassage(CardinalPoint direction) {
		passages.put(direction, true);
	}

	public boolean isCurrent() {
		return isCurrent ;
	}

	public void setCurrent() {
		isCurrent = true;		
	}

	public void move(CardinalPoint direction, boolean isEntering) throws WallException {
		if (isEntering || !isCurrent && !isEntering || isCurrent) {
			if (passages.get(direction)) {
				isCurrent = !isCurrent;
				return;
			}
			throw new WallException();
		}		
	}

	private void prepareMap() {
		passages.put(CardinalPoint.EAST, false);
		passages.put(CardinalPoint.NORTH, false);
		passages.put(CardinalPoint.WEST, false);
		passages.put(CardinalPoint.SOUTH, false);
	}

}
